/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.mrp2;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import cz.insophy.inplan.mrp2.Demand;
import cz.insophy.inplan.mrp2.PropertyTransferer;
import cz.insophy.inplan.mrp2.SortKeyExtractor;
import cz.insophy.inplan.shop.Material;
import javax.annotation.Nonnull;

public class SsDemand
implements Demand {
    @Nonnull
    private final Material material;

    public SsDemand(@Nonnull Material material) {
        this.material = Preconditions.checkNotNull(material);
    }

    @Override
    @Nonnull
    public <T> T extractProperties(@Nonnull PropertyTransferer<T> transferer) {
        return transferer.getProperties(this.material);
    }

    @Override
    @Nonnull
    public Material getMaterial() {
        return this.material;
    }

    @Override
    public double getQty() {
        return this.material.getSafetyStock();
    }

    @Override
    @Nonnull
    public <T extends Comparable<T>> T getSortKey(@Nonnull SortKeyExtractor<T> sortKeyExtractor) {
        return sortKeyExtractor.extract(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("material", this.material.getName()).add("qty", this.material.getSafetyStock()).toString();
    }
}

